<?php
//============================================================+
// File name   : example_002.php
// Begin       : 2008-03-04
// Last Update : 2013-05-14
//
// Description : Example 002 for TCPDF class
//               Removing Header and Footer
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Nicola Asuni
//               Tecnick.com LTD
//               www.tecnick.com
//               info@tecnick.com
//============================================================+
/**
* Creates an example PDF TEST document using TCPDF
* @package com.tecnick.tcpdf
* @abstract TCPDF - Example: Removing Header and Footer
* @author Nicola Asuni
* @since 2008-03-04
*/
// Include the main TCPDF library (search for installation path).
require_once('config/tcpdf_config.php');
require_once('tcpdf.php');
// create new PDF document
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Nicola Asuni');
$pdf->SetTitle('cigna');
$pdf->SetSubject('TCPDF Tutorial');
$pdf->SetKeywords('TCPDF, PDF, example, test, guide');
// set default header data
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);
// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
$pdf->setCellHeightRatio(1.2);
// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
require_once(dirname(__FILE__).'/lang/eng.php');
$pdf->setLanguageArray($l);
}

$pdf->StartTransform();
$pdf->Rotate(-90);
$pdf->Cell(0,0,'This is a sample data',1,1,'L',0,'');
$pdf->StopTransform();
// ---------------------------------------------------------
// set font
$pdf->SetFont('freesans', '', 8);

// add a page
$pdf->AddPage();
/* NOTE:
* *********************************************************
* You can load external XHTML using :
*
* $html = file_get_contents('/path/to/your/file.html');
*
* External CSS files will be automatically loaded.
* Sometimes you need to fix the path of the external CSS.
* *********************************************************
*/
// define some HTML content with style

$html = <<<EOF
<!-- first page -->
<!--header-->
<!DOCTYPE html>
<html>
   <body>
   <style>
    
   .border {
        border: 2px solid red;
        
    }



</style>
<table width="100%" border="0"  cellpadding="0" cellspacing="0">
         <tr>
            <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="0">
              <tr>
                <td style="vertical-align:middle"><table width="100%" border="0" cellspacing="0" cellpadding="5">
                  <tr>
                    <td width="80%"><b>ManipalCigna Health Insurance Company Limited</b><br />
                      (Formerly known as CignaTTK Health Insurance Company Limited)<br />
                      <b>Corporate Office</b>: 401/402, Raheja Titanium, Western Express Highway, Goregaon (East), Mumbai – 400063.
                      IRDAI Registration No. 151 Call (Toll Free): 1800-102-4462<br />
                      <b>Visit</b>: www.manipalcigna.com <br />
                      <b>E-mail</b>: customercare@manipalcigna.com</td>
                    <td width="20%" align="right" style="text-align:right; vertical-align:middle"><img src="images/logo.png" alt="" style="width:150px;" /></td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td align="center">&nbsp;</td>
              </tr>
              <tr>
                <td><table width="100%" border="0" cellspacing="0" cellpadding="5" align="center">
                  <tr>
                    <td width="15%"></td>
                    <td width="70%" align="center" style="border:solid 1px #000000; text-align:center; font-size:20px;"> MANIPALCIGNA LIFETIME HEALTH </td>
                    <td width="15%"></td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td height="5" align="center" style="line-height:5px; height:5px;">&nbsp;</td>
              </tr>
              <tr>
                <td><table width="100%" border="0" cellspacing="0" cellpadding="5" align="center">
                  <tr>
                    <td width="15%"></td>
                    <td width="70%" align="center" style="text-align:center; font-size:20px;"><strong>PORTABILITY FORM1</strong></td>
                    <td width="15%"></td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                  <tr>
                    <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                      <tr>
                        <td style="font-size:15px; font-weight:bold;-webkit-transform: rotate(270deg);
            -moz-transform: rotate(270deg);
            -ms-transform: rotate(270deg);
            -o-transform: rotate(270deg);">PART Idd </td>
           
                      </tr>
                    </table></td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td valign="top">&nbsp;</td>
              </tr>
              <tr>
                <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                  <tr>
                    <td style="font-size:13px; font-weight:bold; background-color:#333; color:#fff; line-height:20px;"><table width="100%" border="0" cellspacing="0" cellpadding="10">
                      <tr>
                        <td>1. PERSONAL DETAILS OF POLICYHOLDER/ INSURED:</td>
                      </tr>
                    </table></td>
                  </tr>
                  <tr>
                    <td valign="top">&nbsp;</td>
                  </tr>
                  <tr>
                    <td valign="top"><table width="100%" border="1" cellspacing="0" cellpadding="0" >
                      <tr>
                        <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="5" >
                          <tr>
                            <td width="26%">Name of the Policy Holder/ Insured:</td>
                            <td width="74%"><table width="100%" border="0" cellpadding="2" cellspacing="0">
                              <tr>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">F</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">I</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">R</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">S</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">T</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">M</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">I</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">D</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">D</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">L</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">E</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                 <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>

                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">S</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">U</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">R</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">N</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">A</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">M</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">E</td>
                              </tr>
                            </table></td>
                          </tr>
                          <tr>
                            <td width="12%">Date of Birth:</td>
                            <td width="88%"><table width="98%" border="0" cellpadding="1" cellspacing="0">
                              <tr>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">D</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">D</td>
                                <td width="4%" style="text-align:center; color:#999;"></td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">M</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">M</td>
                                <td width="4%" style="text-align:center; color:#999;"></td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">Y</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">Y</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">Y</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">Y</td>
                                <td width="3%" style="text-align:center; color:#999;"></td>
                                <td width="6%" style="text-align:center; color:#000;">Age:</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="3%" style="text-align:center; color:#999;"></td>
                                <td width="8%" style="text-align:center; color:#000;">(Years):</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999;"></td>
                                <td width="10%" style="text-align:center; color:#000;">(Months):</td>
                                
                              </tr>
                            </table></td>
                          </tr>
                          <tr>
                            <td width="10%">Email:</td>
                            <td width="90%"><table width="100%" border="0" cellpadding="2" cellspacing="0">
                              <tr>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                              </tr>
                            </table></td>
                          </tr>
                          <tr>
                            <td width="10%">Address:</td>
                            <td width="90%"><table width="100%" border="0" cellpadding="2" cellspacing="0">
                              <tr>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                              </tr>
                            </table></td>
                          </tr>
                          <tr>
                            <td width="10%"></td>
                            <td width="90%"><table width="100%" border="0" cellpadding="2" cellspacing="0">
                              <tr>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                              </tr>
                            </table></td>
                          </tr>
                          <tr>
                            <td width="10%">City</td>
                            <td width="90%"><table width="100%" border="0" cellpadding="1" cellspacing="0">
                              <tr>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="3%" style="text-align:center; color:#999;"></td>
                                <td width="9%" style="text-align:center; color:#000;">State:</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                              </tr>
                            </table></td>
                          </tr>
                          <tr>
                            <td>Pin code:</td>
                            <td><table width="100%" border="0" cellpadding="1" cellspacing="0">
                              <tr>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666;">&nbsp;</td>
                                </tr>
                            </table></td>
                          </tr>
                          
                        </table></td>
                      </tr>

                    </table></td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td valign="top">&nbsp;</td>
              </tr>
              <tr>
                <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                  <tr>
                    <td style="font-size:13px; font-weight:bold; background-color:#333; color:#fff; line-height:20px;"><table width="100%" border="0" cellspacing="0" cellpadding="10">
                      <tr>
                        <td> 2. DETAILS OF EXISTING INSURER:</td>
                      </tr>
                    </table></td>
                  </tr>
                  <tr>
                    <td valign="top">&nbsp;</td>
                  </tr>
                  <tr>
                    <td valign="top"><table width="100%" border="1" cellspacing="0" cellpadding="0">
                      <tr>
                        <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="5">
                          <tr>
                            <td width="20%">i. Name of the Product:</td>
                            <td width="80%"><table width="100%" border="0" cellpadding="2" cellspacing="0">
                              <tr>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                              </tr>
                            </table></td>
                          </tr>
                          <tr>
                            <td width="20%">ii. Sum Insured:</td>
                            <td width="80%"><table width="100%" border="0" cellpadding="2" cellspacing="0">
                              <tr>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                              </tr>
                            </table></td>
                          </tr>
                          <tr>
                            <td width="20%">iii. Cumulative Bonus:</td>
                            <td width="80%"><table width="100%" border="0" cellpadding="2" cellspacing="0">
                              <tr>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                              </tr>
                            </table></td>
                          </tr>
                          <tr>
                            <td width="20%">iv. Add-ons/riders taken:</td>
                            <td width="80%"><table width="100%" border="0" cellpadding="2" cellspacing="0">
                              <tr>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                              </tr>
                            </table></td>
                          </tr>
                          <tr>
                            <td width="20%">v. Policy Number:</td>
                            <td width="80%"><table width="100%" border="0" cellpadding="2" cellspacing="0">
                              <tr>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                              </tr>
                            </table></td>
                          </tr>
                        </table></td>
                      </tr>
                    </table></td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                  <tr>
                    <td style="font-size:13px; font-weight:bold; background-color:#333; color:#fff; line-height:20px;"><table width="100%" border="0" cellspacing="0" cellpadding="10">
                      <tr>
                        <td>3. DETAILS OF THE PROPOSED INSURANCE:</td>
                      </tr>
                    </table></td>
                  </tr>
                  <tr>
                    <td valign="top">&nbsp;</td>
                  </tr>
                  <tr>
                    <td valign="top"><table width="100%" border="1" cellspacing="0" cellpadding="0">
                      <tr>
                        <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                          <tr>
                            <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="5">
                              <tr>
                                <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                  <tr>
                                    <td width="36%">i. Name of the product proposed/intend to take:</td>
                                    <td width="64%"><table width="100%" border="0" cellpadding="2" cellspacing="0">
                                      <tr>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                      </tr>
                                    </table></td>
                                  </tr>
                                </table></td>
                              </tr>
                              <tr>
                                <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                  <tr>
                                    <td width="20%">ii. Sum Insured Proposed:</td>
                                    <td width="80%"><table width="100%" border="0" cellpadding="2" cellspacing="0">
                                      <tr>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                      </tr>
                                    </table></td>
                                  </tr>
                                </table></td>
                              </tr>
                              <tr>
                                <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                  <tr>
                                    <td width="54%">iii. Whether Cumulative Bonus to be converted to an enhanced sum insured:</td>
                                    <td width="46%"><table width="100%" border="0" cellpadding="2" cellspacing="0">
                                      <tr>
                                        <td width="6.25%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="6.25%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="6.25%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="6.25%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="6.25%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="6.25%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="6.25%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="6.25%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="6.25%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="6.25%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="6.25%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="6.25%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="6.25%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="6.25%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="6.25%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="6.25%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                       
                                        
                                      
                                      </tr>
                                    </table></td>
                                  </tr>
                                </table></td>
                              </tr>
                              <tr>
                                <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                  <tr>
                                    <td width="20%">Reason(s) for Portability:</td>
                                    <td width="80%"><table width="100%" border="0" cellpadding="2" cellspacing="0" style="border-bottom:solid 1px #000000">
                                      <tr>
                                        <td>&nbsp;</td>
                                      </tr>
                                    </table></td>
                                  </tr>
                                </table></td>
                              </tr>
                              <tr>
                                <td><table width="100%" border="0" cellpadding="0" cellspacing="0" style="border-bottom:solid 1px #000000">
                                  <tr>
                                    <td>&nbsp;</td>
                                  </tr>
                                </table></td>
                              </tr>
                              <tr>
                                <td><table width="100%" border="0" cellpadding="0" cellspacing="0" style="border-bottom:solid 1px #000000">
                                  <tr>
                                    <td>&nbsp;</td>
                                  </tr>
                                </table></td>
                              </tr>
                              <tr>
                                <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                  <tr>
                                    <td width="45%">No. of family members to be included in the policy to be ported:</td>
                                    <td width="55%"><table width="100%" border="0" cellpadding="2" cellspacing="0" style="border-bottom:solid 1px #000000">
                                      <tr>
                                        <td>&nbsp;</td>
                                      </tr>
                                    </table></td>
                                  </tr>
                                </table></td>
                              </tr>
                              <tr>
                                <td>&nbsp;</td>
                              </tr>
                            </table></td>
                          </tr>
                        </table></td>
                      </tr>
                    </table></td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td>Enclosure: Photocopy of the existing policy documents</td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td valign="top"><table width="100%" border="1" cellspacing="0" cellpadding="5">
                  <tr>
                    <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="5">
                      <tr>
                        <td>&nbsp;</td>
                      </tr>
                      <tr>
                        <td valign="bottom"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                          <tr>
                            <td width="40%" valign="bottom"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                              <tr>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                              </tr>
                              <tr>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                              </tr>
                              <tr>
                                <td width="15%"><b>Date:</b></td>
                                <td width="85%"><table width="100%" border="0" cellpadding="2" cellspacing="0">
                                  <tr>
                                    <td width="10%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">D</td>
                                    <td width="10%" style="text-align:center; color:#999; border:solid 1px #666;">D</td>
                                    <td width="5%" style="text-align:center; color:#999; border:none;">&nbsp;</td>
                                    <td width="10%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">M</td>
                                    <td width="10%" style="text-align:center; color:#999; border:solid 1px #666;">M</td>
                                    <td width="5%" style="text-align:center; color:#999; border:none;">&nbsp;</td>
                                    <td width="10%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">Y</td>
                                    <td width="10%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">Y</td>
                                    <td width="10%" style="text-align:center; color:#999; border:solid 1px #666;">Y</td>
                                    <td width="10%" style="text-align:center; color:#999; border:solid 1px #666;">Y</td>
                                  </tr>
                                </table></td>
                              </tr>
                            </table></td>
                            <td width="30%">&nbsp;</td>
                            <td width="30%" valign="top"><table width="100%" border="0" align="right" cellpadding="0" cellspacing="0">
                              <tr>
                                <td><table width="100%" border="1" cellspacing="0" cellpadding="0">
                                  <tr>
                                    <td height="50">&nbsp;</td>
                                  </tr>
                                </table></td>
                              </tr>
                              <tr>
                                <td align="center"><b>Signature of the Policy Holder</b></td>
                              </tr>
                            </table></td>
                          </tr>
                        </table></td>
                      </tr>
                    </table></td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                  <tr>
                    <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                      <tr>
                        <td style="font-size:15px; font-weight:bold">PART II</td>
                      </tr>

                    </table></td>
                  </tr>
                  <tr>
                <td valign="top">&nbsp;</td>
              </tr>

                  <tr>
                    <td><table width="100%" border="1" cellspacing="0" cellpadding="5">
                      <tr>
                        <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="5">
                          <tr>
                            <td>Whether the PED exclusions/ time bound exclusions have longer exclusion period than the existing policy: (Please indicate Yes/ No)</td>
                          </tr>
                          <tr>
                            <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                              <tr>
                                <td width="10%" valign="bottom">&nbsp;</td>
                                <td width="30%" valign="top"><table width="100%" border="0" cellpadding="1" cellspacing="0">
                                  <tr>
                                    <td width="15%" style="text-align:center; color:#000;">Yes:</td>
                                    <td width="8%" style="text-align:center; color:#999; border:solid 1px #666;"><img src="images/tick.jpg" style="width:7px; height:8px;"></td>
                                    <td width="10%" style="text-align:center; color:#999;"></td>
                                    <td width="10%" style="text-align:center; color:#000;">No</td>
                                    <td width="8%" style="text-align:center; color:#999; border:solid 1px #666;">&nbsp;</td>
                                  </tr>
                                </table></td>
                                <td width="60%" valign="top">&nbsp;</td>
                              </tr>
                            </table></td>
                          </tr>
                          <tr>
                            <td>If Yes, please give written consent to the declaration below:</td>
                          </tr>
                          <tr>
                            <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                              <tr>
                                <td width="55%">I am aware that the waiting period for the following disease(s)/treatment(s) is</td>
                                <td width="10%"><table width="100%" border="0" cellpadding="2" cellspacing="0">
                                  <tr>
                                    <td width="30%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                    <td width="30%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                    <td width="30%" style="text-align:center; color:#999; border:solid 1px #666;">&nbsp;</td>
                                  </tr>
                                </table></td>
                                <td width="35%">days/ years more than the previous policy terms.</td>
                              </tr>
                            </table></td>
                          </tr>
                          <tr>
                            <td>I hereby agree to observe the additional waiting period for the following disease(s)/ treatment(s)</td>
                          </tr>
                          <tr>
                            <td valign="bottom"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                              <tr>
                                <td width="40%" valign="bottom">&nbsp;</td>
                                <td width="30%">&nbsp;</td>
                                <td width="30%" valign="top"><table width="100%" border="0" align="right" cellpadding="0" cellspacing="0">
                                  <tr>
                                    <td><table width="100%" border="1" cellspacing="0" cellpadding="0">
                                      <tr>
                                        <td height="50">&nbsp;</td>
                                      </tr>
                                    </table></td>
                                  </tr>
                                  <tr>
                                    <td align="center"><b>Signature of the Policy Holder</b></td>
                                  </tr>
                                </table></td>
                              </tr>
                            </table></td>
                          </tr>
                        </table></td>
                      </tr>
                    </table></td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td><table width="100%" border="0" cellspacing="0" cellpadding="5">
                  <tr>
                    <td width="80%"><b>ManipalCigna Health Insurance Company Limited</b><br />
                      (Formerly known as CignaTTK Health Insurance Company Limited)<br />
                      <b>Corporate Office</b>: 401/402, Raheja Titanium, Western Express Highway, Goregaon (East), Mumbai – 400063.
                      IRDAI Registration No. 151 Call (Toll Free): 1800-102-4462<br />
                      <b>Visit</b>: www.manipalcigna.com <br />
                      <b>E-mail</b>: customercare@manipalcigna.com</td>
                    <td width="20%" align="right" style="text-align:right; vertical-align:middle"><img src="images/logo.png" alt="" style="width:150px;" /></td>
                  </tr>
                </table></td>
              </tr>
              
              <tr>
                <td><table width="100%" border="0" cellspacing="0" cellpadding="5" align="center">
                  <tr>
                    <td colspan="3"></td>
                  </tr>
                  <tr>
                    <td width="15%"></td>
                    <td width="70%" align="center" style="border:solid 1px #000000; text-align:center; font-size:20px;"> MANIPALCIGNA LIFETIME HEALTH </td>
                    <td width="15%"></td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td><table width="100%" border="0" cellspacing="0" cellpadding="5" align="center">
                  <tr>
                    <td width="15%"></td>
                    <td width="70%" align="center" style="text-align:center; font-size:20px;"><strong>PORTABILITY FORM (ANNEXURE)</strong></td>
                    <td width="15%"></td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td><table width="100%" border="0" cellspacing="0" cellpadding="0" style="border:solid 1px #000;">
                  <tr>
                    <td style="font-size:13px; font-weight:bold; background-color:#333; color:#fff; line-height:20px;"><table width="100%" border="0" cellspacing="0" cellpadding="10">
                      <tr>
                        <td>SECTION A. PERSONAL DETAILS OF POLICYHOLDER/ INSURED:</td>
                      </tr>
                    </table></td>
                  </tr>
                  <tr>
                    <td valign="top">&nbsp;</td>
                  </tr>
                  <tr>
                    <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="0" >
                      <tr>
                        <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                          <tr>
                            <td><table width="100%" border="0" cellspacing="0" cellpadding="5">
                              <tr>
                                <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                  <tr>
                                    <td width="20%"><strong>i) Proposal Number</strong></td>
                                    <td width="80%"><table width="98%" border="0" cellpadding="2" cellspacing="0">
                                      <tr>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                        <td width="4%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                      
                                      </tr>
                                    </table></td>
                                  </tr>
                                  <tr>
                                    <td colspan="2"><strong>ii) Existing Insurance Details</strong></td>
                                  </tr>
                                  <tr>
                                    <td colspan="2"><table width="90%" border="0" cellpadding="5" cellspacing="0">
                                      <tr>
                                        <td width="35%">1. Please indicate whether covered under:</td>
                                        <td width="3%">&nbsp;</td>
                                        <td width="40%"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                          <tr>
                                            <td width="45%"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                              <tr>
                                                <td width="70%">Group Policy</td>
                                                <td width="5%">&nbsp;</td>
                                                <td width="20%"><table width="70%" border="1" cellspacing="0" cellpadding="0">
                                                  <tr>
                                                    <td>&nbsp;</td>
                                                  </tr>
                                                </table></td>
                                              </tr>
                                            </table></td>
                                            <td width="10%">&nbsp;</td>
                                            <td width="45%"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                              <tr>
                                                <td width="70%">Retail Policy</td>
                                                <td width="5%">&nbsp;</td>
                                                <td width="20%"><table width="70%" border="1" cellspacing="0" cellpadding="0">
                                                  <tr>
                                                    <td>&nbsp;</td>
                                                  </tr>
                                                </table></td>
                                              </tr>
                                            </table></td>
                                          </tr>
                                        </table></td>
                                      </tr>
                                    </table></td>
                                  </tr>
                                  <tr>
                                    <td colspan="2"><table width="90%" border="0" cellpadding="5" cellspacing="0">
                                      <tr>
                                        <td width="50%">2. Have you extended your current policy on short term basis?</td>
                                        <td width="4%">&nbsp;</td>
                                        <td width="40%"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                          <tr>
                                            <td width="35%"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                              <tr>
                                                <td width="30%">Yes</td>
                                                <td width="5%">&nbsp;</td>
                                                <td width="25%"><table width="70%" border="1" cellspacing="0" cellpadding="0">
                                                  <tr>
                                                    <td>&nbsp;</td>
                                                  </tr>
                                                </table></td>
                                              </tr>
                                            </table></td>
                                           
                                            <td width="35%"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                              <tr>
                                                <td width="25%">No</td>
                                                <td width="5%">&nbsp;</td>
                                                <td width="25%"><table width="70%" border="1" cellspacing="0" cellpadding="0">
                                                  <tr>
                                                    <td>&nbsp;</td>
                                                  </tr>
                                                </table></td>
                                              </tr>
                                            </table></td>
                                            </tr>
                                          </table></td>
                                        </tr>
                                      </table></td>
                                  </tr>
                                  </table></td>
                              </tr>
                            </table></td>
                          </tr>
                          <tr>
                            <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                              <tr>
                                <td><table width="100%" border="1" cellspacing="0" cellpadding="5">
                                  <tr>
                                    <td>&nbsp;</td>
                                    <td>Insured 1</td>
                                    <td>Insured 2</td>
                                    <td>Insured 3</td>
                                    <td>Insured 4</td>
                                    <td>Insured 5</td>
                                    <td>Insured 6</td>
                                    <td>Insured 7</td>
                                    <td>Insured 8</td>
                                  </tr>
                                  <tr>
                                    <td>Name</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>

                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                  </tr>
                                  <tr>
                                    <td>Policy 1<br />
                                      DOJ (DD/MM/YYYY)</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                  </tr>
                                  <tr>
                                    <td>Sum Insured</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                  </tr>
                                  <tr>
                                    <td>Policy Type</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                  </tr>
                                  <tr>
                                    <td>Cumulative Bonus</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                  </tr>
                                  <tr>
                                    <td>Policy 2<br />
                                      DOJ (DD/MM/YYYY)</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                  </tr>
                                  <tr>
                                    <td>Sum Insured</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                  </tr>
                                  <tr>
                                    <td>Policy Type</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                  </tr>
                                  <tr>
                                    <td>Cumulative Bonus</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                  </tr>
                                  <tr>
                                    <td>Policy 3<br />
                                      DOJ (DD/MM/YYYY)</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                  </tr>
                                  <tr>
                                    <td>Sum Insured</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                  </tr>
                                  <tr>
                                    <td>Policy Type</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                  </tr>
                                  <tr>
                                    <td>Cumulative Bonus</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                  </tr>
                                  <tr>
                                    <td>Policy 4                                      DOJ (DD/MM/YYYY)</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                  </tr>
                                  <tr>
                                    <td>Sum Insured</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                  </tr>
                                  <tr>
                                    <td>Policy Type</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                  </tr>
                                  <tr>
                                    <td>Cumulative Bonus</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                  </tr>
                                  <tr>
                                    <td colspan="9"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                      <tr>
                                        <td width="41%"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                          <tr>
                                            <td width="44%">DOJ - Date of joining</td>
                                            <td width="56%"><table width="100%" border="0" cellpadding="2" cellspacing="0">
                                              <tr>
                                                <td width="10%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                                <td width="10%" style="text-align:center; color:#999; border:solid 1px #666;">&nbsp;</td>
                                                <td width="10%" style="text-align:center; color:#999; border:none;">&nbsp;</td>
                                                <td width="10%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                                <td width="10%" style="text-align:center; color:#999; border:solid 1px #666;">&nbsp;</td>
                                                <td width="10%" style="text-align:center; color:#999; border:none;">&nbsp;</td>
                                                <td width="10%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                                <td width="10%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                                <td width="10%" style="text-align:center; color:#999; border:solid 1px #666;">&nbsp;</td>
                                                <td width="10%" style="text-align:center; color:#999; border:solid 1px #666;">&nbsp;</td>
                                              </tr>
                                            </table></td>
                                          </tr>
                                        </table></td>
                                        <td width="5%">&nbsp;</td>
                                        <td width="54%">Policy Type - Individual or Floater</td>
                                      </tr>
                                    </table></td>
                                    </tr>
                                  <tr>
                                    <td colspan="9"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                      <tr>
                                        <td>iii) Pre- Existing Details</td>
                                        </tr>
                                      <tr>
                                        <td style="border-bottom:none">Pre-exiting details for Proposed Insured Persons (The below section is mandatory. Please fill in NIL where the section is not applicable.)</td>
                                        </tr>
                                      </table></td>
                                  </tr>
                                  </table></td>
                              </tr>
                            </table></td>
                          </tr>
                          <tr>
                            <td><table width="100%" border="1" cellspacing="0" cellpadding="5" style="border-top:none; border-bottom:none;">
                              <tr>
                                <td>S.no</td>
                                <td>Name</td>
                                <td>PED declared</td>
                                <td>No. of years of <br />
                                  Continuous Cover </td>
                                <td>Waiting period completed</td>
                                <td>Waiting period remaining</td>
                              </tr>
                              <tr>
                                <td>Insured 1</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                              </tr>
                              <tr>
                                <td>Insured 2</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                              </tr>
                              <tr>
                                <td>Insured 3</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                              </tr>
                              <tr>
                                <td>Insured 4</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                              </tr>
                              <tr>
                                <td>Insured 5</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                              </tr>
                              <tr>
                                <td>Insured 6</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                              </tr>
                              <tr>
                                <td>Insured 7</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                              </tr>
                              <tr>
                                <td>Insured 8</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                              </tr>
                             
                             
                            </table></td>
                          </tr>
                          
                         
                        </table></td>
                      </tr>
                    </table></td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
               <tr>
                            <td><table width="100%" border="1" cellspacing="0" cellpadding="0">
                              <tr>
                                <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="5">
                                  <tr>
                                    <td><strong>Documents to be provided:</strong></td>
                                  </tr>
                                  <tr>
                                    <td><table width="100%" border="0" cellspacing="5" cellpadding="0">
                                      <tr>
                                        <td>1. Policy Schedule for the previous year(s) as available.</td>
                                        <td>2. Renewal notice for the expiring policy</td>
                                      </tr>
                                    </table></td>
                                  </tr>
                                  <tr>
                                    <td><strong>Acceptance of Portability is subject to the following</strong></td>
                                  </tr>
                                  <tr>
                                    <td valign="top"><table width="100%" border="0" cellspacing="5" cellpadding="0">
                                      <tr>
                                        <td>1. Policy Schedule for the previous year(s) as available.</td>
                                        </tr>
                                      <tr>
                                        <td>1. Application for Portability to ManipalCigna Health Insurance Company Limited is made at least 45 days before the policy renewal date of current insurance policy</td>
                                        </tr>
                                      <tr>
                                        <td>2. Availability of relevant medical / Claim history from previous insurer.</td>
                                        </tr>
                                      <tr>
                                        <td>3. Risk acceptance by Underwriting on evaluation of Proposal form or any Pre Policy Health Check up/ additional information.</td>
                                        </tr>
                                      <tr>
                                        <td>4. Acceptance of revised offer (if any) must be provided within 7 days of intimation.</td>
                                        </tr>
                                      <tr>
                                        <td>5. The company shall not be liable if the application is rejected due to non-adherence to the above guidelines.</td>
                                        </tr>
                                      </table></td>
                                  </tr>
                                  </table></td>
                              </tr>
                            </table></td>
                          </tr>
                           <tr>
                <td height="30"></td>
              </tr>
              <tr>
                <td><table width="100%" border="1" cellspacing="0" cellpadding="5">
                  <tr>
                    <td><table width="100%" border="0" cellspacing="0" cellpadding="5">
                      <tr>
                        <td><strong>Declarations</strong><br />
I understand that my application for portability is being processed and some details are being sought from my current Insurer prior to acceptance of proposed risk. In absence of receipt of the same before expiry of my existing policy, I authorize ManipalCigna Health Insurance Company Limited to process my application based on the information furnished along with the supporting documents provided herein. However, if any variance is subsequently found, ManipalCigna Health Insurance Company Limited shall at its discretion cancel/ modify my coverage through appropriate endorsement and/or take these into consideration while adjudicating any claims under this policy. I also understand that I can extend my existing policy with current insurer to ensure no break in coverage and shall intimate the same in writing to ManipalCigna Health Insurance Company Limited in case of no written communication regarding acceptance of proposed risk on or before expiry of my existing policy.</td>
                      </tr>
                      <tr>
                        <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                          <tr>
                            <td width="40%" valign="bottom"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                              <tr>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                              </tr>
                              <tr>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                              </tr>
                              <tr>
                                <td width="20%">Date</td>
                                <td width="80%"><table width="100%" border="0" cellpadding="2" cellspacing="0">
                                  <tr>
                                    <td width="10%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                    <td width="10%" style="text-align:center; color:#999; border:solid 1px #666;">&nbsp;</td>
                                    <td width="10%" style="text-align:center; color:#999; border:none;">&nbsp;</td>
                                    <td width="10%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                    <td width="10%" style="text-align:center; color:#999; border:solid 1px #666;">&nbsp;</td>
                                    <td width="10%" style="text-align:center; color:#999; border:none;">&nbsp;</td>
                                    <td width="10%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                    <td width="10%" style="text-align:center; color:#999; border:solid 1px #666; border-right:none;">&nbsp;</td>
                                    <td width="10%" style="text-align:center; color:#999; border:solid 1px #666;">&nbsp;</td>
                                    <td width="10%" style="text-align:center; color:#999; border:solid 1px #666;">&nbsp;</td>
                                  </tr>
                                </table></td>
                              </tr>
                            </table></td>
                            <td width="30%">&nbsp;</td>
                            <td width="30%" valign="top"><table width="100%" border="0" align="right" cellpadding="0" cellspacing="0">
                              <tr>
                                <td><table width="100%" border="1" cellspacing="0" cellpadding="0">
                                  <tr>
                                    <td height="50">&nbsp;</td>
                                  </tr>
                                </table></td>
                              </tr>
                              <tr>
                                <td align="center"><b>Signature of the Policy Holder</b></td>
                              </tr>
                            </table></td>
                          </tr>
                        </table></td>
                      </tr>
                    </table></td>
                  </tr>
                </table></td>
              </tr>
              <tr>
                <td>&nbsp;</td>
              </tr>
              <tr>
                <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                  <tr>
                    <td style="font-size:13px; font-weight:bold; background-color:#333; color:#fff; line-height:20px;"><table width="100%" border="0" cellspacing="0" cellpadding="10">
                      <tr>
                        <td>SECTION B: FOR MANIPALCIGNA OPERATIONS TEAM ONLY: The below section is mandatory</td>
                      </tr>
                    </table></td>
                  </tr>
                  <tr>
                    <td valign="top">&nbsp;</td>
                  </tr>
                  <tr>
                    <td valign="top"><table width="100%" border="1" cellspacing="0" cellpadding="0">
                      <tr>
                        <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="5">
                          <tr>
                            <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="5">
                              <tr>
                                <td><table width="90%" border="0" cellpadding="0" cellspacing="0">
                                  <tr>
                                    <td width="38%">i. Details available from previous insurer:</td>
                                    <td width="2%">&nbsp;</td>
                                    <td width="60%"><table width="50%" border="0" cellspacing="0" cellpadding="0">
                                      <tr>
                                        <td width="50%"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                          <tr>
                                            <td width="33%">Yes</td>
                                            <td width="5%">&nbsp;</td>
                                            <td width="51%"><table width="15" border="1" cellpadding="0" cellspacing="0">
                                              <tr>
                                                <td>&nbsp;</td>
                                              </tr>
                                            </table></td>
                                          </tr>
                                        </table></td>
                                        <td width="50%"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                          <tr>
                                            <td width="30%">No</td>
                                            <td width="5%">&nbsp;</td>
                                            <td width="51%"><table width="15" border="1" cellpadding="0" cellspacing="0">
                                              <tr>
                                                <td>&nbsp;</td>
                                              </tr>
                                            </table></td>
                                          </tr>
                                        </table></td>
                                      </tr>
                                    </table></td>
                                  </tr>
                                </table></td>
                              </tr>
                              <tr>

                                <td><table width="90%" border="0" cellpadding="0" cellspacing="0">
                                  <tr>
                                    <td width="13%">1. Claim history:</td>
                                    <td width="1%">&nbsp;</td>
                                    <td width="18%"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                      <tr>
                                        <td width="40%">Positive</td>
                                        <td width="5%">&nbsp;</td>
                                        <td width="51%"><table width="15" border="1" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td>&nbsp;</td>
                                          </tr>
                                        </table></td>
                                      </tr>
                                    </table></td>
                                    <td width="18%"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                      <tr>
                                        <td width="50%">Negative</td>
                                        <td width="5%">&nbsp;</td>
                                        <td width="20%"><table width="15" border="1" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td>&nbsp;</td>
                                          </tr>
                                        </table></td>
                                      </tr>
                                    </table></td>
                                    <td width="17%">2. PED History:</td>
                                    <td width="18%"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                      <tr>
                                        <td width="40%">Positive</td>
                                        <td width="5%">&nbsp;</td>
                                        <td width="20%"><table width="15" border="1" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td>&nbsp;</td>
                                          </tr>
                                        </table></td>
                                      </tr>
                                    </table></td>
                                    <td width="20%"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                      <tr>
                                        <td width="40%">Negative</td>
                                        <td width="5%">&nbsp;</td>
                                        <td width="20%"><table width="15" border="1" cellpadding="0" cellspacing="0">
                                          <tr>
                                            <td>&nbsp;</td>
                                          </tr>
                                        </table></td>
                                      </tr>
                                    </table></td>
                                  </tr>
                                </table></td>
                              </tr>
                              <tr>
                                <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                  <tr>
                                    <td>ii. Declaration in Proposal and Portability Form: Fill in Yes/ No as applicable</td>
                                  </tr>
                                </table></td>
                              </tr>
                              <tr>
                                <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                  <tr>
                                    <td width="20%"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                      <tr>
                                        <td>1. Medical Declarations:</td>
                                        </tr>
                                      </table></td>
                                    <td width="25%"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                      <tr>
                                        <td width="50%"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                          <tr>
                                            <td width="50%">Positive</td>
                                            <td width="5%">&nbsp;</td>
                                            <td width="20%"><table width="15" border="1" cellpadding="0" cellspacing="0">
                                              <tr>
                                                <td>&nbsp;</td>
                                                </tr>
                                              </table></td>
                                            </tr>
                                          </table></td>
                                        <td width="60%"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                          <tr>
                                            <td width="50%">Negative</td>
                                            <td width="5%">&nbsp;</td>
                                            <td width="20%"><table width="15" border="1" cellpadding="0" cellspacing="0">
                                              <tr>
                                                <td>&nbsp;</td>
                                                </tr>
                                              </table></td>
                                            </tr>
                                          </table></td>
                                        </tr>
                                      </table></td>
                                    <td width="37%"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                      <tr>
                                        <td>iii. PPMC Applicable for any person in the policy:</td>
                                        </tr>
                                      </table></td>
                                    <td width="20%"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                      <tr>
                                        <td width="50%"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                          <tr>
                                            <td width="33%">Yes</td>
                                            <td width="5%">&nbsp;</td>
                                            <td width="20%"><table width="15" border="1" cellpadding="0" cellspacing="0">
                                              <tr>
                                                <td>&nbsp;</td>
                                                </tr>
                                              </table></td>
                                            </tr>
                                          </table></td>
                                        <td width="50%"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                          <tr>
                                            <td width="33%">No</td>

                                            <td width="5%">&nbsp;</td>
                                            <td width="51%"><table width="15" border="1" cellpadding="0" cellspacing="0">
                                              <tr>
                                                <td>&nbsp;</td>
                                                </tr>
                                              </table></td>
                                            </tr>
                                          </table></td>
                                        </tr>
                                      </table></td>
                                    </tr>
                                  </table></td>
                              </tr>
                              <tr>
                                <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                  <tr>
                                    <td valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="3">
                                      <tr>
                                        <td height="30"><b>Name of Customer for whom PPMC is applicable for the customer</b></td>
                                        </tr>
                                      <tr>
                                        <td height="30"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                          <tr>
                                            <td width="10%">Insured 1:</td>
                                            <td width="90%"><table width="100%" border="0" cellpadding="2" cellspacing="0" style="border-bottom:solid 1px #000000">
                                              <tr>
                                                <td>&nbsp;</td>
                                                </tr>
                                              </table></td>
                                            </tr>
                                          </table></td>
                                        </tr>
                                      <tr>
                                        <td height="30" valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                          <tr>
                                            <td width="10%">Insured 2:</td>
                                            <td width="90%"><table width="100%" border="0" cellpadding="2" cellspacing="0" style="border-bottom:solid 1px #000000">
                                              <tr>
                                                <td>&nbsp;</td>
                                                </tr>
                                              </table></td>
                                            </tr>
                                          </table></td>
                                        </tr>
                                      <tr>
                                        <td height="30"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                          <tr>
                                            <td width="10%">Insured 3:</td>
                                            <td width="90%"><table width="100%" border="0" cellpadding="2" cellspacing="0" style="border-bottom:solid 1px #000000">
                                              <tr>
                                                <td>&nbsp;</td>
                                                </tr>
                                              </table></td>
                                            </tr>
                                          </table></td>
                                        </tr>
                                      <tr>
                                        <td height="30"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                          <tr>
                                            <td width="10%">Insured 4:</td>
                                            <td width="90%"><table width="100%" border="0" cellpadding="2" cellspacing="0" style="border-bottom:solid 1px #000000">
                                              <tr>
                                                <td>&nbsp;</td>
                                                </tr>
                                              </table></td>
                                            </tr>
                                          </table></td>
                                        </tr>
                                      <tr>
                                        <td height="30"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                          <tr>
                                            <td width="10%">Insured 5:</td>
                                            <td width="90%"><table width="100%" border="0" cellpadding="2" cellspacing="0" style="border-bottom:solid 1px #000000">
                                              <tr>
                                                <td>&nbsp;</td>
                                                </tr>
                                              </table></td>
                                            </tr>
                                          </table></td>
                                        </tr>
                                      <tr>
                                        <td height="30"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                          <tr>
                                            <td width="10%">Insured 6:</td>
                                            <td width="90%"><table width="100%" border="0" cellpadding="2" cellspacing="0" style="border-bottom:solid 1px #000000">
                                              <tr>
                                                <td>&nbsp;</td>
                                                </tr>
                                              </table></td>
                                            </tr>
                                          </table></td>
                                        </tr>
                                      <tr>
                                        <td height="30"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                          <tr>
                                            <td width="10%">Insured 7:</td>
                                            <td width="90%"><table width="100%" border="0" cellpadding="2" cellspacing="0" style="border-bottom:solid 1px #000000">
                                              <tr>
                                                <td>&nbsp;</td>
                                                </tr>
                                              </table></td>
                                            </tr>
                                          </table></td>
                                        </tr>
                                      <tr>
                                        <td height="30"><table width="100%" border="0" cellspacing="0" cellpadding="0">
                                          <tr>
                                            <td width="10%">Insured 8:</td>
                                            <td width="90%"><table width="100%" border="0" cellpadding="2" cellspacing="0" style="border-bottom:solid 1px #000000">
                                              <tr>
                                                <td>&nbsp;</td>
                                                </tr>
                                              </table></td>
                                            </tr>
                                          </table></td>
                                        </tr>
                                      </table></td>
                                    </tr>
                                  </table></td>
                              </tr>
                            </table></td>
                          </tr>
                        </table></td>
                      </tr>
                    </table></td>
                  </tr>
                </table></td>
              </tr>
            </table></td>
      </tr>
   </table>
</html>
EOF;
// output the HTML content
$pdf->writeHTML($html, true, false, true, false, '');
// reset pointer to the last page
$pdf->lastPage();
// ---------------------------------------------------------
//Close and output PDF document
$pdf->Output('example_061.pdf', 'I');
//============================================================+
// END OF FILE
//============================================================+
?>